/**
 * Tebex Store Configuration
 * This file contains all package mappings for Tebex integration.
 */

export const STORE_PACKAGES = {
	// Ranks
	ranks: {
		vip: {
			tpi: 7258582,
			name: 'VIP',
			price: 9.99,
			description: 'Access to VIP perks and features'
		},
		vipplus: {
			tpi: 7258583, // Replace with your actual tpi
			name: 'VIP+',
			price: 19.99,
			description: 'Enhanced VIP experience with more benefits'
		},
		mvp: {
			tpi: 7258584, // Replace with your actual tpi
			name: 'MVP',
			price: 34.99,
			description: 'Maximum value package with all perks'
		},
		legend: {
			tpi: 7258585, // Replace with your actual tpi
			name: 'LEGEND',
			price: 59.99,
			description: 'The ultimate rank with legendary status'
		}
	},

	// Boons
	boons: {
		skycoin_15x: {
			tpi: 8000001, // Replace with your actual tpi
			name: 'Boon of Skycoin (1.5x)',
			price: 1.80,
			description: '1 hour of 1.5x Skycoin earnings'
		},
		skycoin_2x: {
			tpi: 8000002, // Replace with your actual tpi
			name: 'Boon of Skycoin (2x)',
			price: 2.50,
			description: '1 hour of 2x Skycoin earnings'
		},
		crystals_15x: {
			tpi: 8000003, // Replace with your actual tpi
			name: 'Boon of Crystals (1.5x)',
			price: 1.80,
			description: '1 hour of 1.5x Crystal earnings'
		},
		crystals_2x: {
			tpi: 8000004, // Replace with your actual tpi
			name: 'Boon of Crystals (2x)',
			price: 2.50,
			description: '1 hour of 2x Crystal earnings'
		},
		xp_15x: {
			tpi: 8000005, // Replace with your actual tpi
			name: 'Boon of XP (1.5x)',
			price: 1.80,
			description: '1 hour of 1.5x XP earnings'
		},
		xp_2x: {
			tpi: 8000006, // Replace with your actual tpi
			name: 'Boon of XP (2x)',
			price: 2.50,
			description: '1 hour of 2x XP earnings'
		}
	},

	// Crates
	crates: {
		cosmetic: {
			tpi: 9000001, // Replace with your actual tpi
			name: 'Cosmetic Crate',
			price: 1.00,
			description: 'Random cosmetic items and skins'
		},
		map_effects: {
			tpi: 9000002, // Replace with your actual tpi
			name: 'Map Completion Effects Container',
			price: 2.00,
			description: 'Special effects for map completion'
		},
		firework: {
			tpi: 9000003, // Replace with your actual tpi
			name: 'Firework Freight',
			price: 2.50,
			description: 'Explosive firework effects and particles'
		},
		title: {
			tpi: 9000004, // Replace with your actual tpi
			name: 'Title Chest',
			price: 1.50,
			description: 'Unlock unique player titles'
		},
		emc: {
			tpi: 9000005, // Replace with your actual tpi
			name: 'EMC Company Cache',
			price: 5.00,
			description: 'Premium items and exclusive rewards'
		}
	},

	// Crystals
	crystals: {
		paystub: {
			tpi: 10000001, // Replace with your actual tpi
			name: 'Paystub of Crystals',
			price: 0.50,
			description: 'Small crystal bundle',
			quantity: 100
		},
		bonus: {
			tpi: 10000002, // Replace with your actual tpi
			name: 'Bonus of Crystals',
			price: 4.99,
			description: 'Standard crystal bundle',
			quantity: 1000
		},
		salary: {
			tpi: 10000003, // Replace with your actual tpi
			name: 'Salary of Crystals',
			price: 10.99,
			description: 'Large crystal bundle',
			quantity: 5000
		},
		contract: {
			tpi: 10000004, // Replace with your actual tpi
			name: 'Contract of Crystals',
			price: 21.49,
			description: 'Extra large crystal bundle',
			quantity: 10000
		},
		landmark: {
			tpi: 10000005, // Replace with your actual tpi
			name: 'Landmark Cache of Crystals',
			price: 54.99,
			description: 'Massive crystal bundle',
			quantity: 30000
		},
		flagship: {
			tpi: 10000006, // Replace with your actual tpi
			name: 'Flagship Agreement of Crystals',
			price: 119.99,
			description: 'Ultimate crystal bundle',
			quantity: 100000
		}
	}
};

/**
 * Get package details by tpi (Tebex Package ID)
 */
export function getPackageByTpi(tpi) {
	for (const category of Object.values(STORE_PACKAGES)) {
		for (const pkg of Object.values(category)) {
			if (pkg.tpi === tpi) {
				return pkg;
			}
		}
	}
	return null;
}

/**
 * Get all packages as a flat map for quick lookup
 */
export function getPackageMap() {
	const map = {};
	for (const category of Object.values(STORE_PACKAGES)) {
		for (const pkg of Object.values(category)) {
			map[pkg.tpi] = pkg;
		}
	}
	return map;
}
