import { a0 as ensure_array_like, U as attr_style, _ as attr, Y as stringify } from "../../../chunks/index2.js";
import { F as Footer } from "../../../chunks/Footer.js";
import { e as escape_html } from "../../../chunks/context.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const categories = [
      {
        id: "ranks",
        name: "Ranks",
        description: "Unlock exclusive perks and benefits with permanent rank upgrades",
        image: "https://placehold.co/256x256/FFD700/31343C?text=Ranks",
        color: "#FFD700"
      },
      {
        id: "boons",
        name: "Boons",
        description: "Temporary boosters for XP, Skycoins, and Crystals to accelerate your progress",
        image: "https://placehold.co/256x256/9B59B6/31343C?text=Boons",
        color: "#9B59B6"
      },
      {
        id: "crates",
        name: "Crates",
        description: "Mystery boxes filled with cosmetics, effects, and exclusive rewards",
        image: "https://placehold.co/256x256/E67E22/31343C?text=Crates",
        color: "#E67E22"
      },
      {
        id: "crystals",
        name: "Crystals",
        description: "Premium currency bundles for all your in-game purchases",
        image: "https://placehold.co/256x256/3498DB/31343C?text=Crystals",
        color: "#3498DB"
      }
    ];
    $$renderer2.push(`<div class="page svelte-1vodbqu"><div class="container">`);
    {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="store-header svelte-1vodbqu"><h1 class="svelte-1vodbqu">Store</h1> <p class="svelte-1vodbqu">Purchase ranks, boosters, and premium items</p></div> <div class="categories-grid svelte-1vodbqu"><!--[-->`);
      const each_array = ensure_array_like(categories);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let category = each_array[$$index];
        $$renderer2.push(`<button class="category-card svelte-1vodbqu"><div class="category-image svelte-1vodbqu"${attr_style(`background: linear-gradient(135deg, ${stringify(category.color)}22, ${stringify(category.color)}44);`)}><img${attr("src", category.image)}${attr("alt", category.name)} class="category-img svelte-1vodbqu"/></div> <div class="category-plate svelte-1vodbqu"><h3 class="category-name svelte-1vodbqu">${escape_html(category.name)}</h3></div></button>`);
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]--></div></div> `);
    Footer($$renderer2);
    $$renderer2.push(`<!---->`);
  });
}
export {
  _page as default
};
