import { U as attr_style, V as attr_class, W as unsubscribe_stores, X as store_get, Y as stringify, Z as head, _ as attr } from "../../chunks/index2.js";
import { g as getContext } from "../../chunks/context.js";
import "clsx";
import "@sveltejs/kit/internal";
import "../../chunks/exports.js";
import "../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "../../chunks/state.svelte.js";
const getStores = () => {
  const stores$1 = getContext("__svelte__");
  return {
    /** @type {typeof page} */
    page: {
      subscribe: stores$1.page.subscribe
    },
    /** @type {typeof navigating} */
    navigating: {
      subscribe: stores$1.navigating.subscribe
    },
    /** @type {typeof updated} */
    updated: stores$1.updated
  };
};
const page = {
  subscribe(fn) {
    const store = getStores().page;
    return store.subscribe(fn);
  }
};
function Navbar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let progress = 0;
    const fontSize = 20 + progress * 4;
    const bgOpacity = progress * 0.95;
    function isActive(path) {
      return store_get($$store_subs ??= {}, "$page", page).url.pathname === path;
    }
    $$renderer2.push(`<div class="header svelte-d8j1hi" id="header"${attr_style(`background-color: rgba(20, 24, 43, ${stringify(bgOpacity)});`)}><div class="container"><ul class="nav svelte-d8j1hi" id="nav"${attr_style(`font-size: ${stringify(fontSize)}px;`)}><li class="svelte-d8j1hi"><a href="/"${attr_class("svelte-d8j1hi", void 0, { "active": isActive("/") })}>Home</a></li> <li class="svelte-d8j1hi"><a href="/leaderboards"${attr_class("svelte-d8j1hi", void 0, { "active": isActive("/leaderboards") })}>Leaderboards</a></li> <li class="svelte-d8j1hi"><a href="/store"${attr_class("svelte-d8j1hi", void 0, { "active": isActive("/store") })}>Store</a></li> <li class="svelte-d8j1hi"><a href="/help"${attr_class("svelte-d8j1hi", void 0, { "active": isActive("/help") })}>Help</a></li> <li class="svelte-d8j1hi"><a href="https://discord.gg/your-server" target="_blank" rel="noopener noreferrer" class="svelte-d8j1hi">Discord</a></li></ul></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
const favicon = "data:image/png;base64,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";
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { children } = $$props;
    head("12qhfyh", $$renderer2, ($$renderer3) => {
      $$renderer3.push(`<link rel="icon"${attr("href", favicon)}/>`);
    });
    $$renderer2.push(`<div class="main svelte-12qhfyh">`);
    Navbar($$renderer2);
    $$renderer2.push(`<!----> `);
    children($$renderer2);
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _layout as default
};
