import { a0 as ensure_array_like, V as attr_class, _ as attr } from "../../../chunks/index2.js";
import { F as Footer } from "../../../chunks/Footer.js";
import { e as escape_html } from "../../../chunks/context.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let selectedPeriod = "alltime";
    let selectedMode = "overall";
    let loading = true;
    let error = null;
    const periods = [
      { id: "monthly", label: "Monthly", disabled: true },
      { id: "season", label: "Season", disabled: true },
      { id: "alltime", label: "All Time", disabled: false }
    ];
    const modes = [
      { id: "overall", label: "Cream of the Crop" },
      { id: "elytra", label: "Elytra" },
      { id: "parkour", label: "Parkour" }
    ];
    const CACHE_DURATION = 5 * 60 * 1e3;
    const res_origin = "http://elytramc.net:8080/";
    const API_BASE_URL = res_origin + "api/leaderboards";
    let cache = {
      overall: { data: null, timestamp: null },
      elytra: { data: null, timestamp: null },
      parkour: { data: null, timestamp: null }
    };
    let leaderboardData = [];
    function isCacheValid(mode) {
      if (!cache[mode].data || !cache[mode].timestamp) return false;
      const age = Date.now() - cache[mode].timestamp;
      return age < CACHE_DURATION;
    }
    async function fetchLeaderboard(mode) {
      if (isCacheValid(mode)) {
        console.log(`Using cached data for ${mode}`);
        return cache[mode].data;
      }
      console.log(`Fetching fresh data for ${mode}`);
      let url;
      {
        url = `${API_BASE_URL}?type=combined_aggregate`;
      }
      try {
        const response = await fetch(url);
        if (!response.ok) {
          const errorData = await response.json();
          throw new Error(errorData.error || `HTTP ${response.status}`);
        }
        const data = await response.json();
        cache[mode] = { data: data.entries || [], timestamp: Date.now() };
        return cache[mode].data;
      } catch (err) {
        console.error(`Failed to fetch ${mode} leaderboard:`, err);
        throw err;
      }
    }
    function transformApiData(entries, mode) {
      return entries.map((entry, index) => {
        const baseData = {
          rank: index + 1,
          name: entry.playerName,
          uuid: entry.playerUUID,
          face: entry.face,
          texture: entry.texture
        };
        {
          return {
            ...baseData,
            xp: 0,
            // Not available in combined aggregate
            overallScore: entry.totalPoints || 0,
            elytraScore: 0,
            // Would need separate API call
            parkourScore: 0
            // Would need separate API call
          };
        }
      });
    }
    async function loadLeaderboard() {
      loading = true;
      error = null;
      try {
        const entries = await fetchLeaderboard(selectedMode);
        leaderboardData = transformApiData(entries, selectedMode);
      } catch (err) {
        error = err.message;
        leaderboardData = [];
      } finally {
        loading = false;
      }
    }
    {
      loadLeaderboard();
    }
    $$renderer2.push(`<div class="page svelte-16mdp35"><div class="container svelte-16mdp35"><div class="leaderboard-header svelte-16mdp35"><h1 class="svelte-16mdp35">Leaderboards</h1> <p class="svelte-16mdp35">Compete with the best players on our server!</p></div> <div class="tabs-container svelte-16mdp35"><div class="tabs tabs--period svelte-16mdp35"><!--[-->`);
    const each_array = ensure_array_like(
      // Load data on mount
      periods
    );
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let period = each_array[$$index];
      $$renderer2.push(`<button${attr_class("tab svelte-16mdp35", void 0, {
        "tab--active": selectedPeriod === period.id,
        "tab--disabled": period.disabled
      })}${attr("disabled", period.disabled, true)}>${escape_html(period.label)}</button>`);
    }
    $$renderer2.push(`<!--]--></div> <div class="tabs tabs--mode svelte-16mdp35"><!--[-->`);
    const each_array_1 = ensure_array_like(modes);
    for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
      let mode = each_array_1[$$index_1];
      $$renderer2.push(`<button${attr_class("tab svelte-16mdp35", void 0, { "tab--active": selectedMode === mode.id })}>${escape_html(mode.label)}</button>`);
    }
    $$renderer2.push(`<!--]--></div></div> <div class="leaderboard-table-wrapper svelte-16mdp35">`);
    if (loading) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="loading-state svelte-16mdp35"><div class="spinner svelte-16mdp35"></div> <p class="svelte-16mdp35">Loading leaderboard...</p></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      if (error) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="error-state svelte-16mdp35"><p class="svelte-16mdp35">Failed to load leaderboard</p> <p class="error-message svelte-16mdp35">${escape_html(error)}</p> <button class="retry-button svelte-16mdp35">Retry</button></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
        if (leaderboardData.length === 0) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div class="empty-state svelte-16mdp35"><p class="svelte-16mdp35">No leaderboard data available</p></div>`);
        } else {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`<table class="leaderboard-table svelte-16mdp35"><thead class="svelte-16mdp35"><tr class="svelte-16mdp35"><th class="col-rank svelte-16mdp35">Rank</th><th class="col-player svelte-16mdp35">Player</th><th class="col-stat svelte-16mdp35" style="text-align: center;">Score</th></tr></thead><tbody class="svelte-16mdp35"><!--[-->`);
          const each_array_2 = ensure_array_like(leaderboardData);
          for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
            let player = each_array_2[$$index_2];
            $$renderer2.push(`<tr${attr_class("leaderboard-row svelte-16mdp35", void 0, { "leaderboard-row--top3": player.rank <= 3 })}><td class="col-rank svelte-16mdp35"><span${attr_class("rank-badge svelte-16mdp35", void 0, {
              "rank-badge--gold": player.rank === 1,
              "rank-badge--silver": player.rank === 2,
              "rank-badge--bronze": player.rank === 3
            })}>${escape_html(player.rank)}</span></td><td class="col-player svelte-16mdp35"><div class="player-info svelte-16mdp35">`);
            if (player.face) {
              $$renderer2.push("<!--[-->");
              $$renderer2.push(`<img${attr("src", player.face)}${attr("alt", player.name)} class="player-avatar svelte-16mdp35"/>`);
            } else {
              $$renderer2.push("<!--[!-->");
              $$renderer2.push(`<div class="player-avatar player-avatar--fallback svelte-16mdp35">${escape_html(player.name.charAt(0))}</div>`);
            }
            $$renderer2.push(`<!--]--> <span class="player-name svelte-16mdp35">${escape_html(player.name)}</span></div></td><td class="col-stat svelte-16mdp35" style="text-align: center;">`);
            {
              $$renderer2.push("<!--[-->");
              $$renderer2.push(`${escape_html(player.overallScore.toLocaleString())}`);
            }
            $$renderer2.push(`<!--]--></td></tr>`);
          }
          $$renderer2.push(`<!--]--></tbody></table>`);
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></div></div></div> `);
    Footer($$renderer2);
    $$renderer2.push(`<!---->`);
  });
}
export {
  _page as default
};
